<?php

if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 *
 * Button Class
 *
 * @since      2.0.0
 *
 * @package    Let's Review
 * @subpackage lets-review/admin
 */

class Lets_Review_Button {

	/**
	 * Var for slug.
	 *
	 * @since    2.0.0
	 */
	private $slug;

	/**
	 * Var for URL.
	 *
	 * @since    2.0.0
	 */
	private $url;

	/**
	 * Admin Constructor
	 *
	 * @since 2.0.0
	 *
	*/
	public function __construct( $slug, $url ) {

		$this->slug = $slug;
		$this->url = $url;

	}

	/**
	 * Button Init
	 *
	 * @since 2.0.0
	 *
	*/
	public function lets_review_button_init() {
		if ( current_user_can( 'edit_posts' ) || current_user_can( 'edit_pages' ) ) {
			add_filter( 'mce_external_plugins', array( $this, 'lets_review_register' ) );
			add_filter( 'mce_buttons', array( $this, 'lets_review_buttons_callback' ) );
			add_action( 'wp_ajax_lets_review_buttons_insert_dialog', array( $this, 'lets_review_box' ) );
		}
	}

	/**
	 * Button registration callback
	 *
	 * @since 2.0.0
	 *
	*/
	public function lets_review_register( $plugin_array ) {

		$plugin_array['lets_review_buttons'] = $this->url  . 'admin/js/shortcodes.js';
		return $plugin_array;

	}

	/**
	 * Button toolbar callback
	 *
	 * @since 2.0.0
	 *
	*/
	public function lets_review_buttons_callback( $buttons ) {

		$buttons[] = 'lets_review_buttons';
		return $buttons;

	}

	/**
	 * Components Box
	 *
	 * @since    2.0.0
	 */
	public function lets_review_box() {

		$component = intval( $_POST['component'] );
		$strings = $this->lets_review_box_i18n( $component );
		?>

			<div class="lets-review-box-wrap lets-review-wrapper component-<?php echo intval( $component ); ?>">
				<div class="block block-1">
					<h2 class="tipi-title"><?php echo wp_kses_data( $strings['h2'] ); ?></h2>
				</div>
				<?php
				switch ( $component ) {
					case 2:
						$this->lets_review_button_unique();
						break;
					case 3:
						$this->lets_review_button_affiliate();
						break;
					case 4:
						$this->lets_review_button_lists();
						break;
					case 5:
						$this->lets_review_button_userrating();
						break;
					default:
						$this->lets_review_button_existing();
						break;
				}
				?>
			</div><?php
	}

	/**
	 * Existing Reviews
	 *
	 * @since    2.0.0
	 */
	public function lets_review_button_existing() {

	?>
		<div class="block">
			<div class="block-title"><?php echo esc_html__( 'Select post', 'lets-review' ); ?></div>
			<div class="block-content">
				<select class="column-pid">
					<?php $this->lets_review_qry(); ?>
				</select>
			</div>
		</div>
	<?php
	}

	/**
	 * Unique
	 *
	 * @since    2.0.0
	 */
	public function lets_review_button_unique() {

		$this->lets_review_block(
			array(
				'block' => 'text',
				'title' => esc_html__( 'Title (Optional)', 'lets-review' ),
				'name' => 'title',
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'text',
				'title' => esc_html__( 'Subtitle', 'lets-review' ),
				'name' => 'subtitle',
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'text',
				'title' => esc_html__( 'Conclusion Title', 'lets-review' ),
				'name' => 'conclusion-title',
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'textarea',
				'title' => esc_html__( 'Conclusion', 'lets-review' ),
				'name' => 'conclusion',
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'drag',
				'title' => esc_html__( 'Criterias', 'lets-review' ),
				'name' => 'criteria',
				'target' => 'criterias-modal',
				'cb-step' => 1,
				'cb-max' => 100
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'slider',
				'title' => esc_html__( 'Final Score', 'lets-review' ),
				'name' => 'f_score',
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'text',
				'title' => esc_html__( 'Pros Titles', 'lets-review' ),
				'name' => 'prostitle',
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'drag',
				'title' => esc_html__( 'Pros', 'lets-review' ),
				'name' => 'pro',
				'target' => 'pros-modal'
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'text',
				'title' => esc_html__( 'Cons Titles', 'lets-review' ),
				'name' => 'constitle',
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'drag',
				'title' => esc_html__( 'Cons', 'lets-review' ),
				'name' => 'con',
				'target' => 'cons-modal'
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'text',
				'title' => esc_html__( 'Affiliate Title', 'lets-review' ),
				'name' => 'affiliate-title',
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'drag',
				'title' => esc_html__( 'Affiliate Buttons', 'lets-review' ),
				'name' => 'aff',
				'target' => 'affiliates-modal'
			)
		);


		$this->lets_review_block(
			array(
				'block' => 'color',
				'title' => esc_html__( 'Accent Color', 'lets-review' ),
				'name' => 'accent-color',
				'default' => '#444'
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'radioimages',
				'title' => esc_html__( 'Review Style', 'lets-review' ),
				'name' => 'format',
				'choices' => array(
					1 => array( 'img' => 'lr-percent.png', 'title' => esc_html__( 'Percent', 'lets-review' ) ),
					2 => array( 'img' => 'lr-points.png', 'title' => esc_html__( 'Points', 'lets-review' ) ),
					3 => array( 'img' => 'lr-stars.png', 'title' => esc_html__( 'Stars', 'lets-review' ) ),
					4 => array( 'img' => 'lr-custom-icon.png', 'title' => esc_html__( 'Custom Icon', 'lets-review' ) ),
					5 => array( 'img' => 'lr-custom-image.png', 'title' => esc_html__( 'Custom Image', 'lets-review' ) ),
				)
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'text',
				'title' => esc_html__( 'Custom Icon', 'lets-review' ),
				'name' => 'custom_icon_code',
				'required' => 'format',
				'required_value' => 4,
				'hidden'  => 'yes'
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'media',
				'title' => esc_html__( 'Custom Image', 'lets-review' ),
				'name' => 'custom_img',
				'target' => 'custom-img-modal',
				'required' => 'format',
				'required_value' => 5,
				'hidden'  => 'yes'
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'radioimages',
				'title' => esc_html__( 'Design Selection', 'lets-review' ),
				'name' => 'design',
				'choices' => array(
					1 => array( 'img' => 'lr-skin-1.png', 'title' => esc_html__( 'Minimalist', 'lets-review' ) ),
					2 => array( 'img' => 'lr-skin-2.png', 'title' => esc_html__( 'Bold', 'lets-review' ) ),
					5 => array( 'img' => 'lr-skin-5.png', 'title' => esc_html__( 'Clean', 'lets-review' ) ),
					3 => array( 'img' => 'lr-skin-3.png', 'title' => esc_html__( 'Modern', 'lets-review' ) ),
					4 => array( 'img' => 'lr-skin-4.png', 'title' => esc_html__( 'Modern B', 'lets-review' ) ),
				)
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'radioimages',
				'title' => esc_html__( 'Skin Style', 'lets-review' ),
				'name' => 'skin',
				'choices' => array(
					1 => array( 'img' => 'lr-light.png', 'title' => esc_html__( 'Light', 'lets-review' ) ),
					2 => array( 'img' => 'lr-dark.png', 'title' => esc_html__( 'Dark', 'lets-review' ) ),
				),
				'required' => 'design',
				'required_value' => '1,2'
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'radioimages',
				'title' => esc_html__( 'Animation Type', 'lets-review' ),
				'name' => 'animation',
				'choices' => array(
					1 => array( 'img' => 'lr-ani-1.gif', 'title' => esc_html__( 'Incremental', 'lets-review' ) ),
					2 => array( 'img' => 'lr-ani-2.gif', 'title' => esc_html__( 'Fade In', 'lets-review' ) ),
					3 => array( 'img' => 'lr-ani-off.png', 'title' => esc_html__( 'None', 'lets-review' ) ),
				),
				'required' => 'design',
				'required_value' => '1,2'
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'media',
				'title' => esc_html__( 'Main Image', 'lets-review' ),
				'name' => 'mainimg',
				'target' => 'img-modal'
			)
		);

		 $this->lets_review_block(
			array(
				'block' => 'text',
				'title' => esc_html__( 'Gallery Title', 'lets-review' ),
				'name' => 'gallery-title',
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'gallery',
				'title' => esc_html__( 'Gallery', 'lets-review' ),
				'name' => 'gallery',
				'target' => 'gallery-modal'
			)
		);

	}

	/**
	 * User Rating
	 *
	 * @since    2.0.0
	 */
	public function lets_review_button_userrating( $pid = '' ) {

		/* TIPITEMP: Background color needed? 
		$this->lets_review_block(
			array(
				'block' => 'color',
				'title' => esc_html__( 'Background Color', 'lets-review' ),
				'name' => 'color',
				'default' => '#f2f2f2'
			)
		);
		*/

		$this->lets_review_block(
			array(
				'block' => 'text',
				'title' => esc_html__( 'Title (Optional)', 'lets-review' ),
				'name' => 'title',
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'radioimages',
				'title' => esc_html__( 'Review Style', 'lets-review' ),
				'name' => 'format',
				'choices' => array(
					1 => array( 'img' => 'lr-percent.png', 'title' => esc_html__( 'Percent', 'lets-review' ) ),
					2 => array( 'img' => 'lr-points.png', 'title' => esc_html__( 'Points', 'lets-review' ) ),
					3 => array( 'img' => 'lr-stars.png', 'title' => esc_html__( 'Stars', 'lets-review' ) ),
					4 => array( 'img' => 'lr-custom-icon.png', 'title' => esc_html__( 'Custom Icon', 'lets-review' ) ),
					5 => array( 'img' => 'lr-custom-image.png', 'title' => esc_html__( 'Custom Image', 'lets-review' ) ),
				)
			)
		);


		$this->lets_review_block(
			array(
				'block' => 'text',
				'title' => esc_html__( 'Custom Icon', 'lets-review' ),
				'name' => 'custom_icon_code',
				'required' => 'format',
				'required_value' => 4,
				'hidden'  => 'yes'
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'media',
				'title' => esc_html__( 'Custom Image', 'lets-review' ),
				'name' => 'custom_img',
				'target' => 'custom-img-modal',
				'required' => 'format',
				'required_value' => 5,
				'hidden'  => 'yes'
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'radioimages',
				'title' => esc_html__( 'Design Selection', 'lets-review' ),
				'name' => 'design',
				'choices' => array(
					1 => array( 'img' => 'lr-skin-1.png', 'title' => esc_html__( 'Minimalist', 'lets-review' ) ),
					2 => array( 'img' => 'lr-skin-2.png', 'title' => esc_html__( 'Bold', 'lets-review' ) ),
				)
			)
		);
		 

		$this->lets_review_block(
			array(
				'block' => 'media',
				'title' => esc_html__( 'Image', 'lets-review' ),
				'name' => 'img',
				'target' => 'user-img-modal',
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'radioimages',
				'title' => esc_html__( 'Skin Style', 'lets-review' ),
				'name' => 'skin',
				'choices' => array(
					1 => array( 'img' => 'lr-light.png', 'title' => esc_html__( 'Light', 'lets-review' ) ),
					2 => array( 'img' => 'lr-dark.png', 'title' => esc_html__( 'Dark', 'lets-review' ) ),
				),
			)
		);

		 $this->lets_review_block(
			array(
				'block' => 'text',
				'title' => esc_html__( 'Content Title (Optional)', 'lets-review' ),
				'name' => 'content-title',
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'textarea',
				'title' => esc_html__( 'Text content (Optional)', 'lets-review' ),
				'name' => 'content',
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'switch',
				'title' => esc_html__( 'Show User Score Box', 'lets-review' ),
				'name' => 'scorebox'
			)
		);

		$uid = rand( pow( 10, 3 ), pow( 10, 4 ) -1 );
		$this->lets_review_block(
			array(
				'block' => 'hidden',
				'name' => 'id',
				'value' => $uid
			)
		);
	}

	/**
	 * Affiliate
	 *
	 * @since    2.0.0
	 */
	public function lets_review_button_affiliate() {

		$this->lets_review_block(
			array(
				'block' => 'text',
				'title' => esc_html__( 'Button Text', 'lets-review' ),
				'name' => 'title',
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'text',
				'title' => esc_html__( 'Button URL', 'lets-review' ),
				'name' => 'url',
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'color',
				'title' => esc_html__( 'Accent Color', 'lets-review' ),
				'name' => 'color',
				'default' => '#444'
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'select',
				'title' => esc_html__( 'Size', 'lets-review' ),
				'name' => 'size',
				'choices' => array(
					'small' => esc_html__( 'Small', 'lets-review' ),
					'big' => esc_html__( 'Big', 'lets-review' )
				)
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'select',
				'title' => esc_html__( 'Alignment', 'lets-review' ),
				'name' => 'alignment',
				'choices' => array(
					'default' => esc_html__( 'Default', 'lets-review' ),
					'center' => esc_html__( 'Center', 'lets-review' )
				)
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'select',
				'title' => esc_html__( 'Target', 'lets-review' ),
				'name' => 'target',
				'choices' => array(
					'samewindow' => esc_html__( 'Same Window', 'lets-review' ),
					'newwindow' => esc_html__( 'New Window', 'lets-review' )
				)
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'select',
				'title' => esc_html__( 'Rel', 'lets-review' ),
				'name' => 'rel',
				'choices' => array(
					'nofollow' => esc_html__( 'No Follow', 'lets-review' ),
					'follow' => esc_html__( 'Follow', 'lets-review' ),
				)
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'switch',
				'title' => esc_html__( 'Border', 'lets-review' ),
				'name' => 'border'
			)
		);
	}

	/**
	 * Lists
	 *
	 * @since    2.0.0
	 */
	public function lets_review_button_lists() {

		$this->lets_review_block(
			array(
				'block' => 'text',
				'title' => esc_html__( 'Title (Optional)', 'lets-review' ),
				'name' => 'title',
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'select',
				'title' => esc_html__( 'Design Style', 'lets-review' ),
				'name' => 'style',
				'choices' => array(
					'modern' => esc_html__( 'Modern', 'lets-review' ),
					'simple' => esc_html__( 'Simple', 'lets-review' ),
				)
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'select',
				'title' => esc_html__( 'Score Type', 'lets-review' ),
				'name' => 'type',
				'choices' => array(
					1 => esc_html__( 'Editor Scores', 'lets-review' ),
					3 => esc_html__( 'Visitor Scores', 'lets-review' ),
				)
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'select',
				'title' => esc_html__( 'Review Source', 'lets-review' ),
				'name' => 'source',
				'choices' => array(
					1 => esc_html__( 'Posts', 'lets-review' ),
					2 => esc_html__( 'Categories', 'lets-review' ),
					3 => esc_html__( 'Tags', 'lets-review' ),
				)
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'multiselect',
				'title' => esc_html__( 'Select Posts', 'lets-review' ),
				'name' => 'pids',
				'required' => 'source',
				'required_value' => 1,
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'multiselect',
				'title' => esc_html__( 'Select Categories', 'lets-review' ),
				'name' => 'cats',
				'source' => 'cats',
				'required' => 'source',
				'required_value' => 2,
				'hidden'  => 'yes'
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'multiselect',
				'title' => esc_html__( 'Select Tags', 'lets-review' ),
				'name' => 'tags',
				'source' => 'tags',
				'required' => 'source',
				'required_value' => 3,
				'hidden'  => 'yes'
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'number',
				'title' => esc_html__( 'Number of posts', 'lets-review' ),
				'name' => 'numberposts',
				'default' => 1,
				'required' => 'source',
				'required_value' => '2,3',
				'hidden'  => 'yes'
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'select',
				'title' => esc_html__( 'Order', 'lets-review' ),
				'name' => 'order',
				'choices' => array(
					1 => esc_html__( 'Default', 'lets-review' ),
					2 => esc_html__( 'Top Score', 'lets-review' ),
					3 => esc_html__( 'Latest published', 'lets-review' ),
				)
			)
		);

		$this->lets_review_block(
			array(
				'block' => 'switch',
				'title' => esc_html__( 'Show Pros + Cons', 'lets-review' ),
				'name' => 'prosconsonoff'
			)
		);
	}

	/**
	 * Block helper
	 *
	 * @since    2.0.0
	 */
	private function lets_review_block( $args = array() ) {

		$component = intval( $_POST['component'] );
		$strings = $this->lets_review_box_i18n( $component );
		$required = empty( $args['required'] ) ? '' : $args['required'];
		$hidden = empty( $args['hidden'] ) ? '' : ' cb-hidden';
		$required_value = empty( $args['required_value'] ) ? '' : $args['required_value'];

		echo '<div id="' . esc_attr( $args['name'] ) . '" class="block block-' . esc_attr( $args['block'] ) . $hidden . ' lr-cf" data-req="' . esc_attr( $required ) . '" data-req-value="' . esc_attr( $required_value ) . '"><div class="block-content">';
		
		if ( ! empty( $args['title'] ) ) {
			echo  '<div class="block-title">' . wp_kses_data( $args['title'] ) . '</div>';
		}

		switch ( $args['block'] ) {
			case 'switch':
				$args['default'] = empty( $args['default'] ) ? 'off' : $args['default'];
				?>
				<select class="column-<?php echo esc_attr( $args['name'] ); ?>">
					<option value="off" <?php selected( 'off', $args['default'] ); ?>><?php echo esc_html__( 'Off', 'lets-review' ); ?></option>
					<option value="on" <?php selected( 'on', $args['default'] ); ?>><?php echo esc_html__( 'On', 'lets-review' ); ?></option>
				</select>
				<?php
				break;
			case 'select':
				?>
				<select class="column-<?php echo esc_attr( $args['name'] ); ?>">
					<?php foreach ( $args['choices'] as $key => $value ) { ?>
					   <option value="<?php echo esc_attr( $key ); ?>"><?php echo wp_kses_data( $value ); ?></option>
					<?php } ?>
				</select>
				<?php
				break;
			case 'text':
				?>
				<input type="text" class="column-<?php echo esc_attr( $args['name'] ); ?>">
				<?php
				break;
			case 'hidden':
				?>
				<input type="hidden" class="column-<?php echo esc_attr( $args['name'] ); ?>" value="<?php echo esc_attr( $args['value'] ); ?>">
				<?php
				break;
			case 'number':
				$args['default'] = empty( $args['default'] ) ? '' : $args['default'];
				?>
				<input type="number" step="1" min="1" value="<?php echo intval( $args['default'] ); ?>" class="column-<?php echo esc_attr( $args['name'] ); ?>">
				<?php
				break;
			 case 'textarea':
				?>
				<textarea rows="4" cols="50" class="column-<?php echo esc_attr( $args['name'] ); ?>" type="text" id="<?php echo esc_attr( $args['name'] ); ?>" name="<?php echo esc_attr( $args['name'] ); ?>"></textarea>
				<?php
				break;
			case 'color':
				$args['default'] = empty( $args['default'] ) ? '' : $args['default'];
				?>
				<input type="text" class="lets-review-colorpicker column-<?php echo esc_attr( $args['name'] ); ?>" value="<?php echo esc_attr( $args['default'] ); ?>">
				<?php
				break;
			case 'multiselect':
				$source = empty( $args['source'] ) ? '' : $args['source'];
				?>
				<select class="column-<?php echo esc_attr( $args['name'] ); ?> tipi-multiple" multiple="multiple" name="<?php echo esc_attr( $args['name'] ); ?>">
					<?php $this->lets_review_qry( $source ); ?>
				</select>
				<?php
				break;
			case 'radioimages':
				$url =  $this->url . 'admin/images/';
				$args['default'] = empty( $args['default'] ) ? 1 : $args['default'];
				?>
				<div class="column-<?php echo esc_attr( $args['name'] ); ?>">
					<?php foreach ( $args['choices'] as $key => $value ) { ?>
						<div class="cb-radio-images-element">
							<label>
								<span class="cb-radio-title"><?php echo wp_kses_data( $value['title'] ); ?></span>
								<input type="radio" class="cb-input-radio" name="<?php echo esc_attr( $args['name'] ); ?>" value="<?php echo esc_attr( $key ); ?>" <?php checked( $key, $args['default'] ); ?>>
								<img src="<?php echo esc_url( $url . $value['img'] ); ?>" alt="" class="cb-radio-image cb-style-option">
							</label>
						</div>
					<?php } ?>
				</div>
				<?php
				break;
			case 'drag':
				$args['cb-max'] = empty( $args['cb-max'] ) ? '' : $args['cb-max'];
				$args['cb-step'] = empty( $args['cb-step'] ) ? '' : $args['cb-step'];
				?>
				<div class="column-<?php echo esc_attr( $args['name'] ); ?>">
					<ul id="<?php echo esc_attr( $args['target'] ); ?>" data-cb-max="<?php echo esc_attr( $args['cb-max'] ); ?>" data-cb-step="<?php echo esc_attr( $args['cb-step'] ); ?>" data-cb-format="cb-type-1" class="cb-mb ui-sortable lr-cf lets-review-sortable"></ul>
					<a href="#" class="cb-button cb-add-new cb-add-<?php echo esc_attr( $args['name'] ); ?>" data-target="<?php echo esc_attr( $args['target'] ); ?>" data-cb-counter="1"><?php esc_html_e( 'Add', 'lets-review' ); ?></a>
				</div>
				<?php
				break;
			case 'slider':
				?>
				<div class="column-<?php echo esc_attr( $args['name'] ); ?>">
					<div class="cb-criteria-score cb-list-field lr-cf">
						<div class="cb-review-slider cb-slider cb-f-score-modal cb-exclude"></div>
						<input type="text" value="" name="<?php echo esc_attr( $args['name'] ); ?>" id="cb-final-score-modal" class="cb-cri-score column-final-score cb-input" readonly>
					</div>
					<input type="hidden" value="" name="<?php echo esc_attr( $args['name'] ); ?>_100" id="cb-final-score-100-modal" readonly>
				</div>
				<?php
				break;
			case 'media':
				?>
				<div class="column-<?php echo esc_attr( $args['name'] ); ?> cb-media-cont">
					<div id="<?php echo esc_attr( $args['target'] ); ?>" class="lr-cf"></div>
					<a href="#" class="cb-button cb-single-image-trigger" data-cb-name="<?php echo esc_attr( $args['name'] ); ?>" data-cb-dest="<?php echo esc_attr( $args['target'] ); ?>"><?php esc_html_e( 'Add', 'lets-review' ); ?></a>
				</div>
				<?php
				break;
			case 'gallery':
				?>
				<div class="column-<?php echo esc_attr( $args['name'] ); ?> cb-media-cont">
					<div id="<?php echo esc_attr( $args['target'] ); ?>" class="lr-cf"></div>
					<a href="#" class="cb-button cb-gallery-trigger" data-cb-counter="1" data-target="<?php echo esc_attr( $args['target'] ); ?>" data-cb-dest="<?php echo esc_attr( $args['target'] ); ?>"><?php esc_html_e( 'Add', 'lets-review' ); ?></a>
				</div>
				<?php
				break;

			default:
				# code...
				break;
		}

		echo '</div></div>';

	}

	/**
	 * Box i18n
	 *
	 * @since    2.0.0
	 */
	private function lets_review_box_i18n( $component ) {

		$output = array();

		switch ( $component ) {
			case 1:
				$output['h2'] = esc_html__( 'Existing Review Shortcode', 'lets-review' );
				break;
			case 2:
				$output['h2'] = esc_html__( 'Full Review Shortcode', 'lets-review' );
				break;
			case 3:
				$output['h2'] = esc_html__( 'Affiliate Button Shortcode', 'lets-review' );
				break;
			case 4:
				$output['h2'] = esc_html__( 'Lists Shortcode', 'lets-review' );
				break;
		}

		return $output;
	}

	/**
	 * Query helper
	 *
	 * @since    2.0.0
	 */
	public function lets_review_qry( $source = '' ) {

		switch ( $source ) {
			case 'cats':
				$cats = get_categories();
				?>
				<option value="0">
					<?php esc_html_e( 'All Categories', 'lets-review' ); ?>
				</option>
				<?php foreach ( $cats as $cat ) { ?>
					<option value="<?php echo esc_attr( $cat->term_id ); ?>"><?php echo ( $cat->name ) . ' ( ' . $cat->count . ' )'; ?></option>
				<?php }

				break;
			case 'tags':
				$tags = get_tags();
				?>
				<option value="0">
					<?php esc_html_e( 'All Tags', 'lets-review' ); ?>
				</option>
				<?php foreach ( $tags as $tag ) { ?>
					<option value="<?php echo esc_attr( $tag->term_id ); ?>"><?php echo ( $tag->name ) . ' ( ' . $tag->count . ' )'; ?></option>
				<?php }

				break;
			default:
				$cpts = get_post_types( array( 'public' => true, '_builtin' => false ) );
				$cpts[] = 'post';
				$cpts[] = 'page';

				$qry = new WP_Query( array(
					'post_type' => $cpts,
					'posts_per_page' => -1,
					'meta_query' => array(
						array(
							'key' => '_lets_review_onoff',
							'value' => 1,
							'type' => 'BOOLEAN'
						)
					),
					'post_status' => 'publish',
				) );

				if ( $qry->have_posts() ) :
					while ( $qry->have_posts() ) : $qry->the_post();
					?>
					<option value="<?php the_ID(); ?>"><?php the_title(); ?></option>
					<?php
					endwhile;
					wp_reset_postdata();
				endif;

				break;
		}




	}

}